<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\PlayerSetting;
use Spatie\Permission\Models\Role;

class PlayerSettingController extends Controller
{
  public function __construct()
  {
      $this->middleware('permission:player-settings.manage', ['only' => ['get','update']]);
  }
    public function get()
    {
    	$ps = PlayerSetting::first();
    	return view('admin.playersetting.edit',compact('ps'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'logo' => 'mimes:png,jpg,jpeg,webm'
        ]);
    
        $ps = PlayerSetting::first();
        $input = $request->all();
    
        if(isset($ps))
        {
            $ps->cpy_text = $request->cpy_text;
            $ps->subtitle_font_size = $request->subtitle_font_size;
            $ps->subtitle_color = $request->subtitle_color;
            $ps->skin = $request->skin;
          
            // [Previous toggle code remains the same]
    
            if($file = $request->file('logo'))
            {
                $name = 'logo.png';
                
                // Define all skin directories
                $skinDirs = [
                    'minimal_skin_dark',
                    'minimal_skin_white',
                    'classic_skin_dark',
                    'classic_skin_white',
                    'modern_skin_dark',
                    'modern_skin_white'
                ];
                
                // Remove old logo from all skin directories if it exists
                foreach($skinDirs as $dir) {
                    $oldLogoPath = public_path().'/content/'.$dir.'/'.$ps->logo;
                    if($ps->logo != "" && file_exists($oldLogoPath)) {
                        unlink($oldLogoPath);
                    }
                }
                
                // Save new logo to all skin directories
                foreach($skinDirs as $dir) {
                    $destinationPath = public_path().'/content/'.$dir;
                    
                    // Create directory if it doesn't exist
                    if (!file_exists($destinationPath)) {
                        mkdir($destinationPath, 0777, true);
                    }
                    
                    // For the first directory, move the uploaded file
                    if($dir === 'minimal_skin_dark') {
                        $file->move($destinationPath, $name);
                    } else {
                        // For subsequent directories, copy the file
                        copy(public_path().'/content/minimal_skin_dark/'.$name, $destinationPath.'/'.$name);
                    }
                }
                
                $ps->logo = $name;
            }
            
            $ps->save();
        }
        else
        {
            $ps->cpy_text = $request->cpy_text;
            $ps->subtitle_font_size = $request->subtitle_font_size;
            $ps->subtitle_color = $request->subtitle_color;
            
            if ($file = $request->file('logo'))
            {
                $name = 'logo.png';
                
                // Define all skin directories
                $skinDirs = [
                    'minimal_skin_dark',
                    'minimal_skin_white',
                    'classic_skin_dark',
                    'classic_skin_white',
                    'modern_skin_dark',
                    'modern_skin_white'
                ];
                
                foreach($skinDirs as $dir) {
                    $destinationPath = public_path().'/content/'.$dir;
                    
                    // Create directory if it doesn't exist
                    if (!file_exists($destinationPath)) {
                        mkdir($destinationPath, 0777, true);
                    }
                    
                    if($dir === 'minimal_skin_dark') {
                        // For the first directory, optimize and save the original file
                        $optimizeImage = Image::make($file);
                        $optimizeImage->save($destinationPath.'/'.$name, 72);
                    } else {
                        // For subsequent directories, copy the optimized file
                        copy(public_path().'/content/minimal_skin_dark/'.$name, $destinationPath.'/'.$name);
                    }
                }
                
                $input['logo'] = $name;
            }
    
            $ps = PlayerSetting::create($input);
            $ps->save();
        }
        
        return back()->with('success',trans('flash.UpdatedSuccessfully'));
    }
}
