<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Currency;
use Illuminate\Support\Facades\DB;
use Session;
use Spatie\Permission\Models\Role;

class CurrencyController extends Controller
{
    public function __construct()
    {
    
        $this->middleware('permission:currency.view', ['only' => ['show']]);
        
        $this->middleware('permission:currency.edit', ['only' => ['update']]);
        
    
    }
    public function show()
    {

    	$show = Currency::first();
    	return view('admin.currency.edit',compact('show'));
    }

    public function update(Request $request)
    {

    	$data = Currency::first();
        $input = $request->all();

        if(isset($data))
        {
            $data->update($input);
        }
        else
        {
            $data = Currency::create($input);
            $data->save();
        }

		return back()->with('success',trans('flash.UpdatedSuccessfully'));
    }


    public function CurrencySwitch($currency)
    {
        Session::put('changed_currency', $currency);

        $userId = auth()->id();
    
        // Fetch the selected currency data from the currencies table
        $currencyData = DB::table('currencies')
            ->where('code', $currency)
            ->first();
    
        if (!$currencyData) {
            return back()->with('error', 'Currency not found.');
        }
    
        // Delete any previous entries for this user
        DB::table('user_currencies')
            ->where('user_id', $userId)
            ->delete();
    
        // Insert the new currency data into the user_currencies table
        DB::table('user_currencies')
            ->insert([
                'user_id' => $userId,
                'code' => $currencyData->code,
                'name' => $currencyData->name,
                'symbol' => $currencyData->symbol,
                'format' => $currencyData->format,
                'exchange_rate' => $currencyData->exchange_rate,
                'default' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
    
        // Store the selected currency in the session
    
        // Redirect back with success
        return back()->with('success', 'Currency updated successfully.');
    }
    


    
}
