<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Socialite;
use App\User;
use App\Mail\WelcomeUser;
use Illuminate\Support\Facades\Mail;
use App\Setting;
use Twilio\Rest\Client;
use libphonenumber\PhoneNumberUtil;
use libphonenumber\PhoneNumberFormat;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\log;

class AuthController extends Controller
{
   /**
     * Redirect the user to the OAuth Provider.
     *
     * @return Response
     */
    protected $twilioSid = "AC16bdc9457b192da99889cfb5bb534100";
    protected $twilioToken = "239b3a7456da3481cb200f410c82a452";
    protected $twilioNumber = "+12349561590";

    public function redirectToProvider($provider)
    {
        return Socialite::driver($provider)->redirect();
    }

    /**
     * Obtain the user information from provider.  Check if the user already exists in our
     * database by looking up their provider_id in the database.
     * If the user exists, log them in. Otherwise, create a new user then log them in. After that
     * redirect them to the authenticated users homepage.
     *
     * @return Response
     */
    public function handleProviderCallback($provider, Request $request)
    {
        try{
            $user = Socialite::driver($provider)->user();
        }catch(\Exception $ex){
            if(!$request->has('code') || $request->has('denied')) {
                return redirect('/');
            }
            $user = Socialite::driver($provider)->stateless()->user();
        }
        $authUser = $this->findOrCreateUser($user, $provider);
        Auth::login($authUser, true);
        return redirect()->intended('/');
    }

    /**
     * If a user has registered before using social auth, return the user
     * else, create a new user object.
     * @param  $user Socialite user object
     * @param $provider Social auth provider
     * @return  User
     */
    public function findOrCreateUser($user, $provider)
    {
        if($user->email == Null){
            $user->email = $user->id.'@facebook.com';
        }
        $authUser = User::where('email', $user->email)->first();
        $providerField = "{$provider}_id";
        if($authUser){
            if ($authUser->{$providerField} == $user->id) {
                $authUser->email_verified_at = \Carbon\Carbon::now()->toDateTimeString();
                $authUser->save();
                return $authUser;
            }
            else{
                $authUser->{$providerField} = $user->id;
                $authUser->email_verified_at = \Carbon\Carbon::now()->toDateTimeString();
                $authUser->save();
                return $authUser;
            }
        }

        if($user->avatar != NULL && $user->avatar != ""){
            $fileContents = @file_get_contents($user->getAvatar());
            $user_profile = File::put(public_path() . '/images/user_img/' . $user->getId() . ".jpg", $fileContents);
            $name = $user->getId() . ".jpg";
        }
        else {
            $name = NULL;
        }

        $verified = \Carbon\Carbon::now()->toDateTimeString();

        $setting = Setting::first();

        $auth_user = User::create([
            'fname'     => $user->name,
            'email'    => $user->email,
            'user_img'    => $name,
            'email_verified_at'  => $verified,
            $providerField => $user->id,
        ]);

        $auth_user->assignRole('User');
        
        if($setting->w_email_enable == 1){
            try{
               
                Mail::to($auth_user['email'])->send(new WelcomeUser($auth_user));
               
            }
            catch(\Swift_TransportException $e){

            }
        }
        return $auth_user;



    }
//     protected function verify(Request $request)
// {
//     $data = $request->validate([
//         'verification_code' => ['required', 'numeric'],
//         'phone_number' => ['required', 'string'],
//     ]);

//     // Validate and format phone number to E.164 format
//     $phoneUtil = PhoneNumberUtil::getInstance();
//     try {
//         $phoneNumberProto = $phoneUtil->parse($data['phone_number'], "US"); // Assuming default country as US
//         $formattedPhoneNumber = $phoneUtil->format($phoneNumberProto, PhoneNumberFormat::E164);
//     } catch (\libphonenumber\NumberParseException $e) {
//         return back()->with(['phone_number' => $data['phone_number'], 'error' => 'Invalid phone number format!']);
//     }

//     // Use test credentials for non-production environment
//     $token = getenv("TWILIO_AUTH_TOKEN");
//     $twilio_sid = getenv("TWILIO_SID");
//     $twilio_verify_sid = getenv("TWILIO_VERIFY_SID");

//     $twilio = new Client($twilio_sid, $token);

//     try {
//         // Mock the verification response for test environment
//         if (env('APP_ENV') !== 'production') {
//             $verification = (object) ['valid' => $data['verification_code'] === '123456'];
//         } else {
//             // Actual Twilio verification call
//             $verification = $twilio->verify->v2->services($twilio_verify_sid)
//                 ->verificationChecks
//                 ->create([
//                     'code' => $data['verification_code'],
//                     'to' => $formattedPhoneNumber,
//                 ]);
//         }

//         if ($verification->valid) {
//             $user = tap(User::where('phone_number', $data['phone_number']))->update(['isVerified' => true]);
//             // Authenticate user
//             Auth::login($user->first());
//             return redirect()->route('home')->with(['message' => 'Phone number verified']);
//         }

//         return back()->with(['phone_number' => $data['phone_number'], 'error' => 'Invalid verification code entered!']);

//     } catch (RestException $e) {
//         return back()->with(['phone_number' => $data['phone_number'], 'error' => 'Verification failed! Please try again.']);
//     }
// }
    // public function sendOtp(Request $request)
    // {
    //     $request->validate([
    //         'phone_number' => 'required|string',
    //     ]);

    //     // Format the phone number
    //     $phoneUtil = PhoneNumberUtil::getInstance();
    //     try {
    //         $phoneNumberProto = $phoneUtil->parse($request->phone_number, null);
    //         $formattedPhoneNumber = $phoneUtil->format($phoneNumberProto, PhoneNumberFormat::E164);
    //     } catch (\libphonenumber\NumberParseException $e) {
    //         return response()->json(['success' => false, 'message' => 'Invalid phone number format']);
    //     }

    //     // Fetch the credentials from the environment
    //     $token = env("TWILIO_AUTH_TOKEN");
    //     $twilio_sid = env("TWILIO_SID");
    //     $twilio_verify_sid = env("TWILIO_VERIFY_SID");
    //      // Check if environment variables are correctly loaded
    //      if (!$token || !$twilio_sid || !$twilio_verify_sid) {
    //         return response()->json(['success' => false, 'message' => 'Twilio credentials are not set correctly']);
    //     }
    //     // Instantiate the Twilio client
    //     $twilio = new Client($twilio_sid, $token);
    //     try {
    //         $twilio->verify->v2->services($twilio_verify_sid)
    //             ->verifications
    //             ->create($formattedPhoneNumber, "sms");
    //         return response()->json(['success' => true]);
    //     } catch (\Exception $e) {
    //         return response()->json(['success' => false, 'message' => 'Failed to send OTP: ' . $e->getMessage()]);
    //     }
    // }


    public function sendOtp(Request $request)
    {
        try {
            // Validate request
            $request->validate([
                'phone_number' => 'required|string',
                'country_code' => 'required|string',
            ]);

            // Generate 6 digit OTP
            $otp = mt_rand(100000, 999999);
            
            // Store OTP in session
            Session::put('otp', $otp);
            Session::put('phone_number', $request->phone_number);
            Session::put('country_code', $request->country_code);

            // Initialize Twilio
            $client = new Client($this->twilioSid, $this->twilioToken);

            // Send SMS
            $message = $client->messages->create(
                $request->country_code . $request->phone_number,
                [
                    'from' => $this->twilioNumber,
                    'body' => "Your OTP is: " . $otp
                ]
            );

            return response()->json([
                'success' => true,
                'message' => 'OTP sent successfully'
            ]);

        } catch (\Exception $e) {
            \Log::error('OTP Error: ' . $e->getMessage());
            return response()->json([
                'success' => false,
                'message' => 'Failed to send OTP: ' . $e->getMessage()
            ], 500);
        }
    }

    public function verifyOtp(Request $request)
    {
        try {
            // Validate request
            $request->validate([
                'verification_code' => 'required|numeric'
            ]);

            // Get stored OTP and phone
            $storedOtp = Session::get('otp');
            $phoneNumber = Session::get('phone_number');
            $countryCode = Session::get('country_code');

            // Check if OTP exists
            if (!$storedOtp) {
                return response()->json([
                    'success' => false,
                    'message' => 'OTP expired. Please request new OTP.'
                ]);
            }

            // Verify OTP
            if ($request->verification_code == $storedOtp) {
                // Clear OTP session
                Session::forget(['otp', 'phone_number', 'country_code']);

                // Check if user exists
                $completePhone = $countryCode . $phoneNumber;
                $user = User::where('mobile', $completePhone)->first();

                if ($user) {
                    // Login existing user
                    Auth::login($user);
                    return response()->json([
                        'success' => true,
                        'message' => 'Login successful',
                        'redirect' => route('home')
                    ]);
                } else {
                    // Create new user
                    $user = User::create([
                        'fname' => 'User',
                        'mobile' => $completePhone,
                        'email' => $completePhone . '@example.com',
                        'password' => Hash::make('123456'),
                        'email_verified_at' => now()
                    ]);

                    $user->assignRole('User');
                    Auth::login($user);

                    return response()->json([
                        'success' => true,
                        'message' => 'Registration successful',
                        'redirect' => route('home')
                    ]);
                }
            }

            return response()->json([
                'success' => false,
                'message' => 'Invalid OTP'
            ]);

        } catch (\Exception $e) {
            \Log::error('Verification Error: ' . $e->getMessage());
            return response()->json([
                'success' => false,
                'message' => 'Verification failed: ' . $e->getMessage()
            ], 500);
        }
    }
}